<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:chiba="http://chiba.sourceforge.net/2003/08/xforms"
    exclude-result-prefixes="chiba xforms xlink xsl">

    <xsl:param name="css" select="'styles/styles.css'"/>

    <xsl:variable name="uses-dates" select="boolean(//*/@chiba:type='date')" />
    <xsl:variable name="uses-upload" select="boolean(//*/xforms:upload)" />
    <!--
        this stylesheet is generic for browsers that support the DOM more specifically IE5.5+ , Netscape6+ und Mozilla.
    -->

    <xsl:output method="html" encoding="ISO-8859-1" omit-xml-declaration="yes"/>

    <!--<xsl:param name="action-path" select="''"/>-->
    <xsl:param name="action-path" select="''"/>
    <xsl:param name="base-url" select="''"/>
    <xsl:param name="form-id" select="'chiba-form'"/>
    <xsl:param name="form-name" select="'Chiba XForms Processor'"/>

    <xsl:preserve-space elements="*"/>
    <xsl:strip-space elements="xforms:action"/>

    <!-- match html or other surrounding markup -->
    <xsl:template match="/">
        <html>
            <head>
                <title>
                    <xsl:value-of select="$form-name"/>
                </title>
                <script language="javascript" src="scripts/actions.js"/>
                <script language="javascript" src="scripts/commons.js"/>

                <xsl:if test="$uses-dates">
                    <script language='javascript' src='scripts/popcalendar.js'/>
                </xsl:if>
                <link rel="stylesheet" type="text/css" href="{$css}"/>
            </head>
            <body>
                <xsl:element name="form">
                    <xsl:attribute name="name"><xsl:value-of select="$form-id"/></xsl:attribute>
                    <xsl:attribute name="action"><xsl:value-of select="$base-url"/>/<xsl:value-of select="$action-path"/></xsl:attribute>
                    <xsl:attribute name="method">post</xsl:attribute>
                    <xsl:attribute name="enctype">application/x-www-form-urlencoded</xsl:attribute>
                    <xsl:if test="$uses-upload">
                        <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
                    </xsl:if>
                    <xsl:apply-templates select="./*/body/*"/>
                </xsl:element>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="head"/>
    <xsl:template match="body"/>



    <!-- copy unmatched mixed markup, comments, whitespace, and text -->
    <xsl:template match="*|@*|text()">

        <xsl:copy>
            <xsl:apply-templates select="*|@*|text()"/>
        </xsl:copy>
    </xsl:template>

    <!-- skip explicitely disabled control -->
    <xsl:template match="*[chiba:data/@chiba:enabled='false']">
    </xsl:template>

    <!-- skip model section -->
    <xsl:template match="xforms:model">
    </xsl:template>

    <!-- handle group  -->
    <xsl:template match="xforms:group">
        <div class="outergroup" >
            <xsl:if test="xforms:label">
                <span class="outergroup-label">
                    <xsl:apply-templates select="xforms:label"/>
                </span>
            </xsl:if>
            <xsl:for-each select="*[not(name(.)='xforms:label')]">
                <xsl:apply-templates select="."/>
            </xsl:for-each>
        </div>
    </xsl:template>

    <xsl:template match="xforms:group[@class='custom-button-group']" priority="5">
        <span class="custom-button-group">
            <xsl:for-each select="*[not(name(.)='xforms:label')]">
                <xsl:apply-templates select="."/>
            </xsl:for-each>
        </span>
    </xsl:template>

    <xsl:template match="xforms:group[../../xforms:group | ../../xforms:repeat]" name="innergroup">
        <xsl:variable name="id" select="@id"/>
        <xsl:variable name="index" select="@index"/>

        <xsl:if test="xforms:label">
            <div class="innergroup-labelled">
                <div class="innergroup-label">
                    <xsl:apply-templates select="xforms:label"/>
                </div>
                <xsl:for-each select="*[not(name(.)='xforms:label')]">
                    <xsl:apply-templates select="."/>
                </xsl:for-each>
            </div>
        </xsl:if>
        <xsl:if test="not(xforms:label)">
            <div class="innergroup-unlabelled">
                <xsl:apply-templates select="xforms:label"/>
                <xsl:for-each select="*[not(name(.)='xforms:label')]">
                    <xsl:apply-templates select="."/>
                </xsl:for-each>
            </div>
        </xsl:if>

    </xsl:template>

    <!-- ignore transient group -->
    <xsl:template match="xforms:group[@chiba:transient='true']" priority="1">
        <xsl:message>transient group ...</xsl:message>

        <xsl:variable name="repeat-id" select="../@id"/>
        <xsl:variable name="repeat-index" select="../@chiba:index"/>
        <xsl:variable name="repeat-position" select="@chiba:position"/>

        <xsl:choose>
            <xsl:when test="$repeat-index=$repeat-position">
                <div class="repeat-selected" position="{$repeat-position}" onClick="javascript:xf_select_repeat_item('{$repeat-id}',this);return true;">
                    <xsl:call-template name="innergroup"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="repeat-deselected" position="{$repeat-position}" onClick="javascript:xf_select_repeat_item('{$repeat-id}',this);return true;">
                    <xsl:call-template name="innergroup"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="xforms:group[@type='trigger']" priority="2">
        <div class="triggergroup">
        <xsl:for-each select="*[not(name(.)='xforms:label')]">
        <xsl:apply-templates select="."/>
        </xsl:for-each>
        </div>
    </xsl:template>

    <!-- handle repeat -->
    <xsl:template match="xforms:repeat[../../xforms:group | ../../xforms:repeat]" name="innerrepeat">
        <xsl:message>handling repeat ...</xsl:message>
        <div class="repeat" id="{@id}" index="{@chiba:index}">
            <xsl:apply-templates/>
        </div>
    </xsl:template>

    <!-- handle switch -->
    <xsl:template match="xforms:switch">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- handle selected case -->
    <xsl:template match="xforms:case[@xforms:selected='true']">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- skip unselected case -->
    <xsl:template match="xforms:case">
    </xsl:template>

    <!-- handle select -->
    <xsl:template match="xforms:select">
        <span class="select-label">
            <xsl:value-of select="xforms:label"/>
        </span>
        <span class="select-control">
        <xsl:call-template name="select">
            <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
            <xsl:with-param name="value" select="chiba:data/text()"/>
            <xsl:with-param name="appearance" select="@xforms:appearance"/>
        </xsl:call-template>

        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
        </span>
    </xsl:template>

    <!-- handle select1 -->
    <xsl:template match="xforms:select1">
        <span class="select1">
            <span class="select1-label">
                <xsl:value-of select="xforms:label"/>
            </span>
            <span class="select1-control">
                <xsl:call-template name="select1">
                    <xsl:with-param name="name" select="chiba:data/@chiba:name"/>
                    <xsl:with-param name="value" select="chiba:data/text()"/>
                    <xsl:with-param name="appearance" select="@xforms:appearance"/>
                </xsl:call-template>


            <xsl:apply-templates select="xforms:help"/>
            <xsl:apply-templates select="xforms:alert"/>
            </span>
        </span>
    </xsl:template>

    <!-- handle input -->
    <xsl:template match="xforms:input">
        <xsl:variable name="id" select="@id"/>
        <xsl:variable name="curr" select="."/>

        <span class="input">

            <span class="input-label">
                <xsl:value-of select="xforms:label"/>
            </span>
            <span class="input-control">
            <xsl:element name="input">
                <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                <xsl:attribute name="type">text</xsl:attribute>
                <xsl:attribute name="name"><xsl:value-of select="$id" /></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="chiba:data" /></xsl:attribute>
                <!--<xsl:attribute name="style">background-color:transparent;</xsl:attribute>-->
                <!--<xsl:attribute name="class">input-control</xsl:attribute>-->
                <xsl:attribute name="title"><xsl:value-of select="./xforms:hint"/></xsl:attribute>

                <xsl:if test="chiba:data/@chiba:type='date'">
                    <xsl:attribute name="type">button</xsl:attribute>
                    <xsl:attribute name="onclick">
                        javascript:popUpCalendar(this, this, 'dd.mm.yyyy');return true;
                    </xsl:attribute>
                    <xsl:attribute name="onSelect">
                        javascript:popUpCalendar(this, this, 'dd.mm.yyyy');return true;
                    </xsl:attribute>
                    <xsl:attribute name="style">background-color:transparent;</xsl:attribute>
                </xsl:if>

<!--
                <xsl:attribute name="size"><xsl:value-of select="60"/></xsl:attribute>
                <xsl:attribute name="maxlength"><xsl:value-of select="80"/></xsl:attribute>

-->
            </xsl:element>

            <xsl:if test="./chiba:data/@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>

            <xsl:apply-templates select="xforms:help"/>
            <xsl:apply-templates select="xforms:alert"/>
            </span>
        </span>
    </xsl:template>



    <!-- todo: handle as above -->

    <!-- handle textarea -->
    <xsl:template match="xforms:textarea">
        <td><xsl:apply-templates select="xforms:label"/></td>
        <td>
            <xsl:call-template name="textarea">
                <xsl:with-param name="name" select="@chiba:name"/>
                <xsl:with-param name="value" select="chiba:data"/>
                <xsl:with-param name="rows" select="3"/>
                <xsl:with-param name="cols" select="60"/>
            </xsl:call-template>

            <xsl:apply-templates select="xforms:help"/>
            <xsl:apply-templates select="xforms:alert"/>
        </td>
    </xsl:template>

    <!-- handle secret -->
    <xsl:template match="xforms:secret">
        <td><xsl:apply-templates select="xforms:label"/></td>
        <td>
            <xsl:variable name="name" select="@chiba:name"/>
            <xsl:variable name="value" select="chiba:data"/>
            <xsl:variable name="size" select="60"/>

            <xsl:element name="input">
                <xsl:attribute name="name"><xsl:value-of select="$name" /></xsl:attribute>
                <xsl:attribute name="type">password</xsl:attribute>
                <xsl:attribute name="class">secret</xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="./xforms:hint"/></xsl:attribute>
                <xsl:attribute name="size"><xsl:value-of select="$size"/></xsl:attribute>
                <xsl:attribute name="maxlength"><xsl:value-of select="80" /></xsl:attribute>

            </xsl:element>

            <xsl:apply-templates select="xforms:help"/>
            <xsl:apply-templates select="xforms:alert"/>
        </td>
    </xsl:template>

    <!-- handle output -->
    <xsl:template match="xforms:output">

        <xsl:value-of select="chiba:data"/>

        <xsl:apply-templates select="xforms:help"/>
        <xsl:apply-templates select="xforms:alert"/>
    </xsl:template>

    <!-- handle upload -->
    <xsl:template match="xforms:upload">
        <td><xsl:apply-templates select="xforms:label"/></td>
        <td>
            <!-- todo: build html-form-controls template -->

            <xsl:apply-templates select="xforms:help"/>
            <xsl:apply-templates select="xforms:alert"/>
        </td>
    </xsl:template>

    <!-- handle range -->
    <xsl:template match="xforms:range">
        <td><xsl:apply-templates select="xforms:label"/></td>
        <td>
            <!-- todo: build html-form-controls template -->

            <xsl:apply-templates select="xforms:help"/>
            <xsl:apply-templates select="xforms:alert"/>
        </td>
    </xsl:template>

    <!-- handle trigger / submit -->
    <xsl:template match="xforms:trigger|xforms:submit">
        <span class="trigger-control">
            <xsl:element name="input">
                <xsl:attribute name="type">button</xsl:attribute>
                <xsl:attribute name="name"><xsl:value-of select="chiba:data/@chiba:name"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="xforms:label"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="xforms:hint"/></xsl:attribute>
                <xsl:call-template name="eval-actions"/>
            </xsl:element>
        </span>
        <xsl:apply-templates select="xforms:help|xforms:alert"/>
    </xsl:template>

    <xsl:template name="eval-actions">
        <xsl:if test="xforms:insert|xforms:delete">
            <xsl:attribute name="onClick">javascript:<xsl:apply-templates select="xforms:insert|xforms:delete"/>return true;</xsl:attribute>
        </xsl:if>
    </xsl:template>

    <!-- handle image trigger -->
    <xsl:template match="xforms:trigger[starts-with(./xforms:label/@xlink:href,'images')]">
        <span class="trigger-control">
            <xsl:element name="input">
                <xsl:attribute name="type">image</xsl:attribute>
                <xsl:attribute name="name"><xsl:value-of select="chiba:data/@chiba:name"/></xsl:attribute>
                <xsl:attribute name="value"><xsl:value-of select="xforms:label"/></xsl:attribute>
                <xsl:attribute name="src"><xsl:value-of select="xforms:label/@xlink:href"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="xforms:hint"/></xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="xforms:hint"/></xsl:attribute>
                <xsl:call-template name="eval-actions"/>
            </xsl:element>
        </span>
        <xsl:apply-templates select="xforms:help|xforms:alert"/>

    </xsl:template>

    <!-- handle label -->
    <xsl:template match="xforms:label">
        <xsl:copy-of select="*|text()"/>
    </xsl:template>

    <!-- handle hint -->
    <xsl:template match="xforms:hint">

        <!--  already handled by html-form-controls.xsl -->
    </xsl:template>

    <!-- handle help -->
    <xsl:template match="xforms:help">

        <!-- this implementation renders a button to display a javascript message -->
        <img src="images/help.gif" onClick="javascript:xf_help('{normalize-space(.)}');return true;"/>
<!--         -->
<!--        <xsl:element name="input">-->
<!--            <xsl:attribute name="type">button</xsl:attribute>-->
<!--            <xsl:attribute name="value">?</xsl:attribute>-->
<!--            <xsl:attribute name="class">help</xsl:attribute>-->
<!--            <xsl:attribute name="onClick">javascript:xf_help('<xsl:value-of select="normalize-space(.)"/>');return true;</xsl:attribute>-->
<!--        </xsl:element>-->

    </xsl:template>

    <!-- handle explicitely enabled alert -->
    <xsl:template match="xforms:alert[../chiba:data/@chiba:valid='false']">

        <br/>
        <b>
            <font color="red" size="-1">
                <xsl:value-of select="." />
            </font>
        </b>

    </xsl:template>

    <!-- skip alert -->
    <xsl:template match="xforms:alert">
    </xsl:template>

    <!-- handle extensions -->
    <xsl:template match="xforms:extension">
        <xsl:apply-templates/>
    </xsl:template>


    <!-- ########################## ACTIONS ####################################################### -->
    <!-- ########################## ACTIONS ####################################################### -->
    <!-- ########################## ACTIONS ####################################################### -->

    <!-- action nodes are simply copied to output without any modification -->

        <xsl:template match="xforms:dispatch">
            <xsl:copy-of select="."/>
        </xsl:template>

        <xsl:template match="xforms:refresh">
            <xsl:copy-of select="."/>
        </xsl:template>

        <xsl:template match="xforms:recalculate">
            <xsl:copy-of select="."/>
        </xsl:template>
<!--
        <xsl:template match="xforms:revalidate">
            <xsl:copy-of select="."/>
        </xsl:template>

        <xsl:template match="xforms:setFocus">
            <xsl:copy-of select="."/>
        </xsl:template>

        <xsl:template match="xforms:setValue">
            <xsl:copy-of select="."/>
        </xsl:template>

        <xsl:template match="xforms:submitInstance">
            <xsl:copy>
                <xsl:variable name="submission" select="@xforms:submission"/>
                <xsl:for-each select="//xforms:submission[@id=$submission]/@*">
                    <xsl:copy/>
                </xsl:for-each>
            </xsl:copy>
        </xsl:template>

        <xsl:template match="xforms:resetInstance">
            <xsl:copy-of select="."/>
        </xsl:template>
-->

    <xsl:template match="xforms:action">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- this implementation always uses the current index position (chiba:index) as reference for inserting -->
    <xsl:template match="xforms:insert">
        <xsl:variable name="ref" select="@chiba:repeatref"/>
        <xsl:text>xf_insert('</xsl:text><xsl:value-of select="$ref"/><xsl:text>');</xsl:text>
    </xsl:template>

    <xsl:template match="xforms:delete">
        <xsl:variable name="ref" select="@chiba:repeatref"/>
        <xsl:text>xf_delete('</xsl:text><xsl:value-of select="$ref"/><xsl:text>');</xsl:text>
    </xsl:template>
    <!--

        <xsl:template match="xforms:setindex">
            <xsl:call-template name="setindex"/>
        </xsl:template>

        <xsl:template match="xforms:toggle">
            <xsl:copy-of select="."/>
        </xsl:template>

        <xsl:template match="xforms:message">
            <xsl:copy-of select="."/>
        </xsl:template>

       <xsl:template match="xforms:loadURI">
            <xsl:copy-of select="."/>
        </xsl:template>
    -->
    



<xsl:template name="select1">
	<xsl:param name="name"/>
	<xsl:param name="value"/>
	<xsl:param name="appearance"/>

	<xsl:variable name="parent" select="." />
    <!-- todo: provide default -->
	<xsl:choose>
		<xsl:when test="$appearance='minimal'">
			<xsl:element name="select">
				<xsl:attribute name="name"><xsl:value-of select="$name" /></xsl:attribute>
				<xsl:attribute name="size">1</xsl:attribute>
<!--                <xsl:attribute name="class">select1-control</xsl:attribute> -->
                <xsl:attribute name="title"><xsl:value-of select="./xforms:hint"/></xsl:attribute>
				<xsl:call-template name="build-items">
					<xsl:with-param name="value" select="$value"/>
					<xsl:with-param name="parent" select="$parent"/>
				</xsl:call-template>
			</xsl:element>
            <xsl:if test="./@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
		</xsl:when>
		<xsl:when test="$appearance='compact'">
			<xsl:element name="select">
				<xsl:attribute name="name"><xsl:value-of select="$name" /></xsl:attribute>
				<xsl:attribute name="size">5</xsl:attribute>
                <!--<xsl:attribute name="class">select1-control</xsl:attribute>-->
                <xsl:attribute name="title"><xsl:value-of select="./xforms:hint"/></xsl:attribute>
				<xsl:call-template name="build-items">
					<xsl:with-param name="value" select="$value"/>
					<xsl:with-param name="parent" select="$parent"/>
				</xsl:call-template>
			</xsl:element>
            <xsl:if test="./@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
		</xsl:when>
		<xsl:when test="$appearance='full'">
            <xsl:call-template name="build-radiobuttons">
                <xsl:with-param name="name" select="$name"/>
                <xsl:with-param name="value" select="$value"/>
                <xsl:with-param name="parent" select="$parent"/>
            </xsl:call-template>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="build-items">
	<xsl:param name="value"/>
	<xsl:param name="parent"/>

    <!-- add an empty item, cause otherwise deselection is not possible -->
    <option value=""/>

	<xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="./xforms:value=$value">
					<option value="{./xforms:value}" selected="true">
						<xsl:value-of select="./xforms:label" />
					</option>
                </xsl:when>
                <!-- look for list-items (xforms:select) -->
                <xsl:when test="contains(concat(' ',$value),concat(' ',./xforms:value))">
					<option value="{./xforms:value}" selected="true">
						<xsl:value-of select="./xforms:label" />
					</option>
                </xsl:when>
                <xsl:otherwise>
					<option value="{./xforms:value}">
						<xsl:value-of select="./xforms:label" />
					</option>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:for-each>
</xsl:template>

<xsl:template name="select">
	<xsl:param name="name"/>
	<xsl:param name="value"/>
	<xsl:param name="appearance" />

	<xsl:variable name="parent" select="." />
<xsl:message>SELECT called: appearance: <xsl:value-of select="$appearance"/></xsl:message>
	<xsl:choose>
		<xsl:when test="$appearance='minimal'">
        <xsl:message>MINIMAL</xsl:message>
			<xsl:element name="select">
				<xsl:attribute name="name"><xsl:value-of select="$name" /></xsl:attribute>
				<xsl:attribute name="size">3</xsl:attribute>
				<xsl:attribute name="multiple">true</xsl:attribute>
                <xsl:attribute name="class">select-control</xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="./xforms:hint"/></xsl:attribute>
				<xsl:call-template name="build-items">
					<xsl:with-param name="value" select="$value"/>
					<xsl:with-param name="parent" select="$parent"/>
				</xsl:call-template>
			</xsl:element>
            <xsl:if test="./@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
		</xsl:when>
		<xsl:when test="$appearance='compact'">
			<xsl:element name="select">
				<xsl:attribute name="name"><xsl:value-of select="$name" /></xsl:attribute>
				<xsl:attribute name="size">5</xsl:attribute>
				<xsl:attribute name="multiple">true</xsl:attribute>
                <xsl:attribute name="class">select-control</xsl:attribute>
                <xsl:attribute name="title"><xsl:value-of select="./xforms:hint"/></xsl:attribute>
				<xsl:call-template name="build-items">
					<xsl:with-param name="value" select="$value"/>
					<xsl:with-param name="parent" select="$parent"/>
				</xsl:call-template>
			</xsl:element>
            <xsl:if test="./@chiba:required='true'">
                <font color="red">*</font>
            </xsl:if>
		</xsl:when>
		<xsl:when test="$appearance='full'">
        <xsl:message>FULL</xsl:message>
            <xsl:call-template name="build-checkboxes">
                <xsl:with-param name="name" select="$name"/>
                <xsl:with-param name="value" select="$value"/>
                <xsl:with-param name="parent" select="$parent"/>
            </xsl:call-template>
<!-- 			<xsl:for-each select=".//xforms:item">
				todo: selected or not?
				<input type="checkbox" name="{$name}" value="{$value}" />
			</xsl:for-each>
            -->
		</xsl:when>
	</xsl:choose>


</xsl:template>

<!-- overwrite/change this template, if you don't like the way labels are rendered for checkboxes -->
<xsl:template name="build-checkboxes">

    <xsl:param name="name"/>
	<xsl:param name="value"/>
	<xsl:param name="parent"/>
    <xsl:param name="type"/> <!-- this must be 'checkbox' or 'radio' -->
<xsl:message>BUILD_CHECKBOXES</xsl:message>
	<xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:choose>
                <xsl:when test="./xforms:value=$value">
                    <input type="checkbox" name="{$name}" value="{$value}" checked="true" title="{./xforms:hint}" />
                </xsl:when>
                <!-- look for list-items (xforms:select) -->
                <xsl:when test="contains(concat(' ',$value),concat(' ',./xforms:value))">
                    <input type="checkbox" name="{$name}" value="{./xforms:value}" checked="true" title="{./xforms:hint}" />
                </xsl:when>
                <xsl:otherwise>
                    <input type="checkbox" name="" value=""  title="{./xforms:hint}"/>
                    <!-- cause non-checked checkboxes send no param a hidden input is added instead to take its place -->
                    <input type="hidden" name="{$name}" value="" />
                </xsl:otherwise>
            </xsl:choose>

            <xsl:apply-templates select=".//xforms:label"/>

        </xsl:for-each>
        <xsl:if test="./@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
</xsl:template>

<!-- overwrite/change this template, if you don't the way labels are rendered for checkboxes -->
<xsl:template name="build-radiobuttons">
    <xsl:param name="name"/>
    <xsl:param name="value"/>
	<xsl:param name="parent"/>

<xsl:message>BUILD_RADIOBUTTONS</xsl:message>
	<xsl:variable name="items" select="$parent//xforms:item"/>
        <xsl:for-each select="$items">
            <xsl:variable name="cur_val" select="./xforms:value"/>
            <xsl:choose>
                <xsl:when test="./xforms:value=$value">
                    <input type="radio" name="{$name}" value="{$cur_val}" checked="true" title="{./xforms:hint}"/>
                </xsl:when>
                <!-- look for list-items (xforms:select)
                <xsl:when test="contains(concat(' ',$value),concat(' ',./xforms:value))">
                    <input type="radio" name="{$name}" value="{$value}" checked="true"/>
                </xsl:when>
                 -->
                <xsl:otherwise>
                    <input type="radio" name="{$name}" value="{$cur_val}" title="{./xforms:hint}"/>
                </xsl:otherwise>
            </xsl:choose>
            <!-- <xsl:copy-of select=".//xforms:label" /> -->
            <xsl:apply-templates select=".//xforms:label"/>

        </xsl:for-each>
        <xsl:if test="./@chiba:required='true'">
            <font color="red">*</font>
        </xsl:if>
</xsl:template>

<xsl:template name="range">
</xsl:template>

<xsl:template name="submit">
	<xsl:variable name="submission" select="//xforms:submission[@id=@xforms:submission]" />

<!--	<input type="submit" name="chiba:head/trigger/{./@id}" value="{./xforms:label}" />-->
	<input type="submit" name="{@chiba:name}" value="{./xforms:label}" />
</xsl:template>


<xsl:template name="image-trigger">
	<input type="image"
           name="{@chiba:name}"
           value="{./xforms:label}"
           src="{xforms:label/@xlink:href}"
           title="{xforms:label}"/>
</xsl:template>

<!-- support for custom chiba:index param. Can be used in local scripts to change the value the server receives
for update -->
<xsl:template name="setindex">
    <xsl:param name="repeat-node" />
    <xsl:param name="index" />

    <xsl:choose>
        <xsl:when test="$repeat-node/@chiba:index=$index">
            <input type="radio" name="chiba:head/cursor/{$repeat-node/@id}" value="{$index}" checked="true"/>
        </xsl:when>
        <xsl:otherwise>
            <input type="radio" name="chiba:head/cursor/{$repeat-node/@id}" value="{$index}"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


    
</xsl:stylesheet>

